const { spacing } = require('tailwindcss/defaultTheme');
const colors = require('tailwindcss/colors');


module.exports = {
    mode: process.env.TAILWIND_COMPILE_MODE || 'aot', // either 'jit' or 'aot'
    theme: {
        extend: {
            screens: {
                'xs': {'max': '420px'},
                 // => @media (max-width: 420px) { ... }
                'sm': '640px',
                // => @media (min-width: 640px) { ... }
                'md': '768px',
                // => @media (min-width: 768px) { ... }
                'lg': '1024px',
                // => @media (min-width: 1024px) { ... }
                'xl': '1280px',
                // => @media (min-width: 1280px) { ... }
                '2xl': '1536px',
                // => @media (min-width: 1536px) { ... }
            },
            fontFamily: {
                'montserrat': ['Montserrat']
            },
            lineHeight: {
                'extra-loose': '2.5',
                '12': '3rem',
                '2': '.5rem'
              },
            letterSpacing: {
                tightest: '-.075em',
                tighter: '-.05em',
                tight: '-.025em',
                normal: '0',
                wide: '.025em',
                wider:'.03em',
                widerer: '.05em',
                widest: '.1em',
                custom1:'.029em',
                custom2: '.054em',
                custom3: '.04em',
                custom4: '.035em',
                custom5: '.017em'
            },
            colors: {
                primary: {
                    lighter: '#EB001B',
                    "DEFAULT": '#C60E42',
                    darker: '#A0002F',
                },
                secondary: {
                    lighter: colors.blue['100'],
                    "DEFAULT": colors.blue['200'],
                    darker: colors.blue['300'],
                },
                background: {
                    lighter: colors.blue['100'],
                    "DEFAULT": colors.blue['200'],
                    darker: colors.blue['300'],
                    darkBurgundy: '#961238',
                }
            },
            textColor: {
                orange: colors.orange,
                primary: {
                    lighter: '#707070',
                    "DEFAULT": '#606060',
                    darker: '#000000',
                },
                secondary: {
                    lighter: '#e7e7e7',
                    "DEFAULT": '#c7c7c7',
                    darker: '#b6b6b6',
                },
                main: {
                    lighter: '#ff0000',
                    "DEFAULT": '#C60E42',
                    darker: '#A0002F',
                },
            },
            backgroundSize: {
                'auto': 'auto',
                'cover': 'cover',
                'contain': 'contain',
                '50%': '50%',
                '16': '4rem',
                '8':'2rem',
                '4':'1rem'
                },
            backgroundColor: {
                primary: {
                    lighter: '#EB001B',
                    "DEFAULT": '#C60E42',
                    darker: '#A0002F',
                },
                secondary: {
                    lighter: '#f4f4f4',
                    "DEFAULT": '#606060',
                    darker: '#0A0B09',
                },
                container: {
                    lighter: '#ffffff',
                    "DEFAULT": '#fafafa',
                    darker: '#f5f5f5',
                }
            },
            borderColor: {
                primary: {
                    lighter: '#EB001B',
                    "DEFAULT": '#C60E42',
                    darker: '#A0002F',
                },
                secondary: {
                    lightest: '#f4f4f4',
                    lighter: '#e7e7e7',
                    "DEFAULT": '#c7c7c7',
                    darker: '#606060',
                    darkerer: '#707070',
                    darkest: '#000000'
                },
                container: {
                    lighter: '#f5f5f5',
                    "DEFAULT": '#e7e7e7',
                    darker: '#d4d4d4',
                }
            },
            dropShadow: {
                'card': '0 3px 6px rgba(0, 0, 0, 0.29)',
              },
            boxShadow: {
                'custom': '0 3px 6px rgb(0, 0, 0, 0.29)',
                'custom1': '3px 3px 6px rgb(0, 0, 0, 0.29)',
            },
            minWidth: {
                8: spacing["8"],
                20: spacing["20"],
                40: spacing["40"],
                48: spacing["48"],
            },
            minHeight: {
                14: spacing["14"],
                'screen-25': '25vh',
                'screen-50': '50vh',
                'screen-75': '75vh',
            },
            maxHeight: {
                '0': '0',
                'screen-25': '25vh',
                'screen-50': '50vh',
                'screen-75': '75vh',
            },
            container: {
                center: true,
                padding: '1.5rem'
            }
        },
    },
    variants: {
        extend: {
            borderWidth: ['last', 'hover', 'focus'],
            margin: ['last'],
            opacity: ['disabled'],
            backgroundColor: ['even', 'odd'],
            ringWidth: ['active']
        }
    },
    plugins: [
        require('@tailwindcss/forms'),
        require('@tailwindcss/typography'),
    ],
    purge: {
        // Examples for excluding patterns from purge
        // options: {
        //     safelist: [/^bg-opacity-/, /^-?[mp][trblxy]?-[4,8]$/, /^text-shadow/],
        // },
        content: [
            // this theme's phtml files
            '../../**/*.phtml',
            // parent theme in Vendor (if this is a child-theme)
            '../../../../../../../app/code/Hyva/**/*.phtml',
            '../../../../../../../app/code/FoundationCommerce/**/*.phtml',
            '../../../../../../../vendor/hyva-themes/magento2-default-theme/**/*.phtml',
            // app/code phtml files (if need tailwind classes from app/code modules)
            '../../../../../../../app/code/**/*.phtml',
            // react app src files (if Hyvä Checkout is installed in app/code)
            //'../../../../../../../app/code/**/src/**/*.jsx',
            // react app src files in vendor (If Hyvä Checkout is installed in vendor)
            //'../../../../../../../vendor/hyva-themes/magento2-hyva-checkout/src/reactapp/src/**/*.jsx',
            //'../../../../../../../vendor/hyva-themes/magento2-hyva-checkout/src/view/frontend/templates/react-container.phtml',
            // widget block classes from app/code
            // '../../../../../../../app/code/**/Block/Widget/**/*.php'
        ]
    }
}
