<?php

namespace Nublue\CountdownTimer\Helper;

class Data extends \Magento\Framework\App\Helper\AbstractHelper
{
	/**
	 *	@var $scopeConfig
	 */
	protected $scopeConfig;

	/**
	 *	@param \Magento\Framework\App\Config\scopeConfigInterface $scopeConfig
	 */
	public function __construct(
		\Magento\Framework\App\Config\scopeConfigInterface $scopeConfig
	)
	{
		$this->scopeConfig = $scopeConfig;
	}

	public function getConfig($key, $type="exact") 
	{
		$val = $this->scopeConfig->getValue(
			"countdowntimer/settings/",
			\Magento\Store\Model\ScopeInterface::SCOPE_STORE
		);

		if ($type == "bool") {
			$val = filter_var($val, FILTER_VALIDATE_BOOLEAN);
		}

		return $val;
	}
}