<?php

//New Comment

namespace Nublue\CountdownTimer\Controller\Index;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\Result\JsonFactory;
use Magento\Store\Model\ScopeInterface;

class Index extends Action
{
    /**
     * Configuration keys
     */
    const CONFIG_KEY_PROCESSING_DAYS = 'countdowntimer/nb_shipping_settings/processing_days';
    const CONFIG_KEY_DELIVERY_DAYS = 'countdowntimer/nb_shipping_settings/delivery_days';
    const CONFIG_KEY_CUTOFF_TIME = 'countdowntimer/nb_shipping_settings/cutoff_time';

	/**
     *  @var $scopeConfig
     */
    protected $scopeConfig;
    protected $resultJsonFactory;

    /**
     * @param Context $context
     */
    public function __construct(
        Context $context,
		\Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
         JsonFactory $resultJsonFactory
    ) {
        parent::__construct($context);

        $this->scopeConfig = $scopeConfig;

        $this->resultJsonFactory = $resultJsonFactory;

        // set the correct time zone
        date_default_timezone_set($this->scopeConfig->getValue('general/locale/timezone', \Magento\Store\Model\ScopeInterface::SCOPE_STORE));
    }

    protected function isSkipDay($date)
	{
        $availableDaysRaw = $this->scopeConfig->getValue('countdowntimer/nb_shipping_settings/available_days', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);

        if (!empty($availableDaysRaw)) {
            $availableDays = explode(",", $availableDaysRaw);
            $weekday = date('w', strtotime($date));
            if (!in_array($weekday, $availableDays)) {
                return true;
            }
        }

        $skipDaysRaw = $this->scopeConfig->getValue('countdowntimer/nb_shipping_settings/skip_days', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);

        if (!empty($skipDaysRaw)) {
            $skipDaysJson = json_decode($skipDaysRaw, true);
            if(is_array($skipDaysJson)){
                $skipDays = array_map(function ($ar) {return date("Y-m-d", strtotime($ar['Date']));}, $skipDaysJson)  ;
            } else {
                return false;
            }

            return (in_array($date, $skipDays));
        }

        return false;
	}

	protected function getDeliveryData()
	{
        $currentDate = date('Y-m-d H:i:s');

        // Read values
        $processingDays = $this->getConfigValue(self::CONFIG_KEY_PROCESSING_DAYS);
        $deliveryDays = $this->getConfigValue(self::CONFIG_KEY_DELIVERY_DAYS);
        $cutoffTime = $this->getConfigValue(self::CONFIG_KEY_CUTOFF_TIME);

        // Set default values
        if ($processingDays === '') $processingDays = 3;
        if ($deliveryDays === '') $deliveryDays = 3;
        if ($cutoffTime === '') $cutoffTime = '23:59';

        // Add processing days to delivery days
        $deliveryDays += $processingDays;

        $cutoffTime = explode(':', $cutoffTime);
        $dateNow = new \DateTime($currentDate);
        $dispatchDate = new \DateTime($currentDate);

        $addExtraDay = false;

        if (strtotime($dateNow->format('H:i:00')) > strtotime($cutoffTime[0] . ':' . $cutoffTime[1] . ':00')) {
            $dispatchDate->modify('+1 day');
            $addExtraDay = true;
        }

        do {
            if ($this->isSkipDay($dispatchDate->format('Y-m-d'))) {
                $dispatchDate->modify('+1 day');
            } else  {
                break;
            }
        } while (true);

        $dispatchDate->setTime($cutoffTime[0], $cutoffTime[1]);
        $cuttoff = $dispatchDate->format('F d, Y H:i:s');
        $deliveryDate = new \DateTime($dispatchDate->format($dispatchDate::ISO8601));

        if ($deliveryDays > 1) {
            $numOfDaysSkipped = 0;

            for ($i=0; $i < $deliveryDays; $i++) {
                $deliveryDate->modify('+1 day');

                if ($this->isSkipDay($deliveryDate->format('Y-m-d'))) {
                    $numOfDaysSkipped++;
                }
            }

            if ($numOfDaysSkipped > 0) {
                $deliveryDate->modify('+' . $numOfDaysSkipped . ' day');
            }

        } else {
            $deliveryDate->modify('+' . $deliveryDays . ' day');
        }

        $isSkipDay = true;

        while ($isSkipDay === true) {
            if ($this->isSkipDay($deliveryDate->format('Y-m-d'))) {
                $deliveryDate->modify('+1 day');
            } else {
                $isSkipDay = false;
            }
        }

        $explodeStatement = $deliveryDate->format('F-l-d-S');
        $dateComponents = explode('-', $explodeStatement);
        $monthFormat = __($dateComponents[0]);
        $dayFormat = __($dateComponents[1]);
        $dayNumberFormat = $dateComponents[2] . __($dateComponents[3]);

        $translatedDate = $dayFormat. ' ' . $dayNumberFormat . ' ' . $monthFormat;

        return array('delivery_date' => $translatedDate, 'now' => date('F d, Y H:i:s'), 'cutoff' => $cuttoff);
    }

    public function execute()
    {

    	$result = $this->resultJsonFactory->create();
        if ($this->getRequest()->isAjax())
        {
            return $result->setData($this->getDeliveryData());
        }

    }

    /**
     * Getter for magento configuration values
     * @param string $path
     * @return string
     */
    public function getConfigValue($path)
    {
        return $this->scopeConfig->getValue($path, ScopeInterface::SCOPE_STORE);
    }
}
