<?php
declare(strict_types=1);

namespace FoundationCommerce\ThemeViewModels\ViewModels;;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Store\Model\Information as StoreInfo;
use Magento\Store\Model\ScopeInterface;
use Magento\Store\Model\StoreManagerInterface;

class StoreInfoProvider implements ArgumentInterface
{
    /**
     * @var ScopeConfigInterface
     */
    protected $scopeConfig;
    /**
     * @var StoreInfo
     */
    protected $storeInfo;
    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;
    protected \Magento\Framework\Locale\Resolver $localeResolver;

    public function __construct(
        ScopeConfigInterface $scopeConfig,
        StoreManagerInterface $storeManager,
        StoreInfo $storeInfo,
        \Magento\Framework\Locale\Resolver $localeResolver
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->storeInfo = $storeInfo;
        $this->storeManager = $storeManager;
        $this->localeResolver = $localeResolver;
    }

    public function getStoreNumber():string
    {
        $phone = $this->storeInfo->getStoreInformationObject($this->storeManager->getStore())->getPhone();

        if (is_string($phone)) {
            return $phone;
        }

        return '';
    }

    public function getStoreEmail():string
    {
        return $this->scopeConfig->getValue('trans_email/ident_sales/email', ScopeInterface::SCOPE_STORE);
    }

    public function getStoreAddress(): string
    {
        $address = $this->storeInfo->getFormattedAddress($this->storeManager->getStore());

        if (is_string($address)) {
            return $address;
        }

        return '';
    }

    public function getStoreLocale()
    {
        return $this->localeResolver->getLocale();
    }
}
