<?php

namespace FoundationCommerce\ThemeViewModels\ViewModels;

use Magento\Catalog\Api\Data\CategoryInterface;
use Magento\Catalog\Model\ResourceModel\Category\Collection as CategoryCollection;
use Magento\Framework\Registry;
use Magento\Framework\View\Element\Block\ArgumentInterface;

class CurrentCategoryDataProvider implements ArgumentInterface
{
    /**
     * @var Registry
     */
    protected $registry;

    public function __construct(
        Registry $registry
    ) {
        $this->registry = $registry;
    }

    public function getCurrentCategory(): CategoryInterface
    {
        return $this->registry->registry('current_category');
    }

    public function getChildCategoryCollection(): CategoryCollection
    {
        return $this->getCurrentCategory()->getChildrenCategories();
    }
}
