<?php

namespace FoundationCommerce\ThemeSetup\Setup\Patch\Data;

use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchRevertableInterface;
use Magento\Cms\Model\BlockFactory;
use Magento\Cms\Model\Block as CmsBlock;
use Magento\Cms\Api\BlockRepositoryInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Store\Model\Store;

/**
 * Class UpdateBlockData
 * @package FoundationCommerce\ThemeSetup\Setup\Patch\Data
 */
class UpdateBlockData
    implements DataPatchInterface,
    PatchRevertableInterface
{
    /**
     * @var BlockFactory
     */
    protected $_blockFactory;

      /**
     * @var BlockRepositoryInterface
     */
    protected $_blockRepository;

    /**
     * UpdateBlockData constructor.
     *
     * @param BlockFactory $blockFactory
     * @param BlockRepositoryInterface $blockRepository
     */
    public function __construct(
        BlockFactory $blockFactory,
        BlockRepositoryInterface $blockRepository
    ) {
        $this->_blockFactory = $blockFactory;
        $this->_blockRepository = $blockRepository;
     }

    /**
     * {@inheritdoc}
     */
    public function apply()
    {
        $cmsBlocksData = [
            [
                'title'      => 'Header Notice',
                'identifier' => 'header_notice_block',
                'content'    => '<div>Covid-19 Update: We Deliver As Per Usual - Stay Healthy!</div>',
                'is_active'  => CmsBlock::STATUS_ENABLED,
                'stores'     => Store::DEFAULT_STORE_ID
            ],
            [
                'title'      => 'Footer Column1 Links',
                'identifier' => 'footer-column1-links',
                'content'    => '<ul><li><a href="/about-us/">About Pi-Shop</a></li><li><a href="/imprint/">Imprint</a></li><li><a href="/payment/">Payment</a></li><li><a href="/delivery/">Delivery</a></li></ul>',
                'is_active'  => CmsBlock::STATUS_ENABLED,
                'stores'     => Store::DEFAULT_STORE_ID
            ],
            [
                'title'      => 'Footer Column2 Links',
                'identifier' => 'footer-column2-links',
                'content'    => '<ul><li><a href="/customer/account/">Login / Account</a></li><li><a href="/faqs">FAQs</a></li><li><a href="/terms-and-conditions/">Terms &amp; Conditions</a></li><li><a href="/privacy-policy-cookie-restriction-mode/">Privacy & Security</a></li></ul>',
                'is_active'  => CmsBlock::STATUS_ENABLED,
                'stores'     => Store::DEFAULT_STORE_ID
            ],
            [
                'title'      => 'Limited Quantity Block',
                'identifier' => 'limited-quantity-block',
                'content'    => '<span>Due to current limited availability, the quantity is limited to <strong>1 unit per customer.</strong></span>',
                'is_active'  => CmsBlock::STATUS_ENABLED,
                'stores'     => Store::DEFAULT_STORE_ID
            ]
        ];

        foreach ($cmsBlocksData as $cmsBlockData) {
            /** @var CmsBlock $block */
            try {
                $this->_blockRepository->getById($cmsBlockData['identifier']);
            } catch (NoSuchEntityException $e) {
                $block = $this->_blockFactory->create();
                $block->setData($cmsBlockData);
                $this->_blockRepository->save($block);
            }
        }
    }

    /**
     * {@inheritdoc}
     */
    public static function getDependencies()
    {
        /**
         * No dependencies for this
         */
        return [];
    }

    /**
     * Delete the block
     */
    public function revert()
    {
        $cmsBlocksIds = ['header_notice_block', 'footer-column1-links', 'footer-column2-links', 'limited-quantity-block'];
        foreach ($cmsBlocksIds as $cmsBlockId) {
            try {
                $this->_blockRepository->deleteById($cmsBlockId);
            } catch (NoSuchEntityException $e) {
                // do nothing
            }
        }
    }

    /**
     * {@inheritdoc}
     */
    public function getAliases()
    {
        /**
         * Aliases are useful if we change the name of the patch until then we do not need any
         */
        return [];
    }
}
