<?php
declare(strict_types=1);

namespace FoundationCommerce\BrandCategories\Setup\Patch\Data;

use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchRevertableInterface;
use Magento\Catalog\Model\Category;
use Magento\Catalog\Setup\CategorySetupFactory;
use Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface;
use Magento\Eav\Setup\EavSetup;
use Magento\Eav\Setup\EavSetupFactory;

class CreateBrandCategoryAttributes implements
    DataPatchInterface,
    PatchRevertableInterface
{
    /**
     * @var ModuleDataSetupInterface
     */
    protected $moduleDataSetup;

    public function __construct(
        ModuleDataSetupInterface $moduleDataSetup,
        EavSetupFactory $eavSetupFactory,
        CategorySetupFactory $categorySetupFactory
    ) {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->eavSetupFactory = $eavSetupFactory;
        $this->categorySetupFactory = $categorySetupFactory;
    }

    /**
     * {@inheritdoc}
     */
    public function apply()
    {
        /** @var EavSetup $eavSetup */
        $eavSetup = $this->eavSetupFactory->create(['setup' => $this->moduleDataSetup]);

            $eavSetup->removeAttribute(Category::ENTITY, 'totonic_is_brand');
            $eavSetup->addAttribute(Category::ENTITY, 'totonic_is_brand', [
            'type' => 'int',
            'label' => 'Is A Brand Category?',
            'input' => 'select',
            'sort_order' => 50,
            'source' => 'Magento\Eav\Model\Entity\Attribute\Source\Boolean',
            'visible' => true,
            'required' => false,
            'global' => ScopedAttributeInterface::SCOPE_STORE,
            'user_defined' => true,
            'default' => 0,
            'group' => 'Brand Attributes',
        ]);

        $eavSetup->removeAttribute(Category::ENTITY, 'totonic_brand_logo');
        $eavSetup->addAttribute(
            Category::ENTITY,
            'totonic_brand_logo',
            [
                'type' => 'varchar',
                'label' => 'Brand Logo',
                'input' => 'image',
                'backend' => 'Magento\Catalog\Model\Category\Attribute\Backend\Image',
                'required' => false,
                'sort_order' => 6,
                'global' => ScopedAttributeInterface::SCOPE_STORE,
                'group' => 'Brand Attributes',
            ]
        );
    }

    /**
     * {@inheritdoc}
     */
    public static function getDependencies()
    {
        return [];
    }

    public function revert()
    {
    }

    /**
     * {@inheritdoc}
     */
    public function getAliases()
    {
        return [];
    }
}
